:- use_module(library(clpfd)).

% LIST OF SUPPLIERS - USE ONLY NUMBERS

sup(1).
sup(2).
% sup(3).
% sup(4).

% LIST OF BENEFITS

benefit(highDecreaseCosts).
benefit(averageDecreaseCosts).
benefit(fairDecreaseCosts).
benefit(poorDecreaseCosts).

% benefit(highSpendingControl).
% benefit(averageSpendingControl).
% benefit(fairSpendingControl).
% benefit(poorSpendingControl).

% benefit(highEnhancedCommunication).
% benefit(averageEnhancedCommunication).
% benefit(fairEnhancedCommunication).
% benefit(poorEnhancedCommunication).

% LIST Of CONTRACT CLAUSES

contractclause(q1).

% LINKS FROM FEATURES TO BENEFITS

myRule(benefit(highDecreaseCosts,X),[f1(X),f7(X),f10(X)]).
myRule(benefit(highDecreaseCosts,X),[f4(X),f7(X),f10(X)]).
myRule(benefit(highDecreaseCosts,X),[f7(X),f9(X),f10(X)]).

myRule(benefit(averageDecreaseCosts,X),[f1(X),f3(X),f10(X)]).
myRule(benefit(averageDecreaseCosts,X),[f1(X),f7(X)]).
myRule(benefit(averageDecreaseCosts,X),[f1(X),f9(X),f10(X)]).
myRule(benefit(averageDecreaseCosts,X),[f3(X),f4(X),f10(X)]).
myRule(benefit(averageDecreaseCosts,X),[f3(X),f9(X),f10(X)]).
myRule(benefit(averageDecreaseCosts,X),[f4(X),f7(X)]).
myRule(benefit(averageDecreaseCosts,X),[f4(X),f9(X),f10(X)]).
myRule(benefit(averageDecreaseCosts,X),[f7(X),f9(X)]).
myRule(benefit(averageDecreaseCosts,X),[f7(X),f10(X)]).

myRule(benefit(fairDecreaseCosts,X),[f3(X),f1(X)]).
myRule(benefit(fairDecreaseCosts,X),[f3(X),f4(X)]).
myRule(benefit(fairDecreaseCosts,X),[f9(X)]).
myRule(benefit(fairDecreaseCosts,X),[f7(X)]).
myRule(benefit(fairDecreaseCosts,X),[f3(X),f10(X)]).
myRule(benefit(fairDecreaseCosts,X),[f1(X),f10(X)]).
myRule(benefit(fairDecreaseCosts,X),[f4(X),f10(X)]).

myRule(benefit(poorDecreaseCosts,X),[f1(X)]).
myRule(benefit(poorDecreaseCosts,X),[f3(X)]).
myRule(benefit(poorDecreaseCosts,X),[f4(X)]).
myRule(benefit(poorDecreaseCosts,X),[f7(X)]).
myRule(benefit(poorDecreaseCosts,X),[f9(X)]).
myRule(benefit(poorDecreaseCosts,X),[f10(X)]).

% myRule(benefit(highSpendingControl,X),[f1(X),f4(X),f5(X),f8(X)]).
% myRule(benefit(highSpendingControl,X),[f1(X),f4(X),f5(X),f9(X)]).
% myRule(benefit(highSpendingControl,X),[f1(X),f4(X),f8(X),f9(X)]).
% myRule(benefit(highSpendingControl,X),[f1(X),f5(X),f8(X),f9(X)]).
% myRule(benefit(highSpendingControl,X),[f4(X),f5(X),f8(X),f9(X)]).

% myRule(benefit(averageSpendingControl,X),[f1(X),f4(X),f5(X)]).
% myRule(benefit(averageSpendingControl,X),[f1(X),f4(X),f8(X)]).
% myRule(benefit(averageSpendingControl,X),[f1(X),f4(X),f9(X)]).
% myRule(benefit(averageSpendingControl,X),[f1(X),f5(X),f8(X)]).
% myRule(benefit(averageSpendingControl,X),[f1(X),f5(X),f9(X)]).
% myRule(benefit(averageSpendingControl,X),[f1(X),f8(X),f9(X)]).
% myRule(benefit(averageSpendingControl,X),[f4(X),f5(X),f8(X)]).
% myRule(benefit(averageSpendingControl,X),[f4(X),f8(X),f9(X)]).
% myRule(benefit(averageSpendingControl,X),[f5(X),f8(X),f9(X)]).

% myRule(benefit(fairSpendingControl,X),[f1(X),f4(X)]).
% myRule(benefit(fairSpendingControl,X),[f1(X),f5(X)]).
% myRule(benefit(fairSpendingControl,X),[f1(X),f8(X)]).
% myRule(benefit(fairSpendingControl,X),[f1(X),f9(X)]).
% myRule(benefit(fairSpendingControl,X),[f4(X),f5(X)]).
% myRule(benefit(fairSpendingControl,X),[f4(X),f8(X)]).
% myRule(benefit(fairSpendingControl,X),[f4(X),f9(X)]).
% myRule(benefit(fairSpendingControl,X),[f5(X),f8(X)]).
% myRule(benefit(fairSpendingControl,X),[f5(X),f9(X)]).
% myRule(benefit(fairSpendingControl,X),[f8(X),f9(X)]).

% myRule(benefit(poorSpendingControl,X),[f1(X)]).
% myRule(benefit(poorSpendingControl,X),[f4(X)]).
% myRule(benefit(poorSpendingControl,X),[f5(X)]).
% myRule(benefit(poorSpendingControl,X),[f8(X)]).
% myRule(benefit(poorSpendingControl,X),[f9(X)]).

% myRule(benefit(highEnhancedCommunication,X),[f1(X),f2(X),f5(X),f6(X)]).

% myRule(benefit(averageEnhancedCommunication,X),[f1(X),f2(X),f5(X)]).
% myRule(benefit(averageEnhancedCommunication,X),[f1(X),f2(X),f6(X)]).
% myRule(benefit(averageEnhancedCommunication,X),[f1(X),f5(X),f6(X)]).
% myRule(benefit(averageEnhancedCommunication,X),[f2(X),f5(X),f6(X)]).

% myRule(benefit(fairEnhancedCommunication,X),[f1(X),f2(X)]).
% myRule(benefit(fairEnhancedCommunication,X),[f1(X),f5(X)]).
% myRule(benefit(fairEnhancedCommunication,X),[f1(X),f6(X)]).
% myRule(benefit(fairEnhancedCommunication,X),[f2(X),f5(X)]).
% myRule(benefit(fairEnhancedCommunication,X),[f2(X),f6(X)]).
% myRule(benefit(fairEnhancedCommunication,X),[f5(X),f6(X)]).

% myRule(benefit(poorEnhancedCommunication,X),[f1(X)]).
% myRule(benefit(poorEnhancedCommunication,X),[f2(X)]).
% myRule(benefit(poorEnhancedCommunication,X),[f5(X)]).
% myRule(benefit(poorEnhancedCommunication,X),[f6(X)]).

% OFFERS FROM THE SUPPLIERS

myRule(f1(1),[]).
myRule(f2(1),[]).
myRule(f5(1),[]).
myRule(f8(1),[]).
myRule(f10(1),[]).

myRule(f2(2),[]).
myRule(f5(2),[]).
myRule(f6(2),[]).
myRule(f8(2),[]).
myRule(f9(2),[]).

myRule(f1(3),[]).
myRule(f4(3),[]).
myRule(f5(3),[]).
myRule(f6(3),[]).
myRule(f9(3),[]).

myRule(f1(4),[]).
myRule(f4(4),[]).
myRule(f5(4),[]).
myRule(f8(4),[]).
myRule(f9(4),[]).

% ATTACK RULES

myRule(c(X,Y,B),[benefit(B,Y),mnot(B,X)]) :- sup(X), sup(Y), benefit(B), all_different([X,Y]).

% ASSUMPTIONS

myAsm(sup(X)).
myAsm(mnot(B,X)) :- benefit(B), sup(X).
myAsm(Q) :- contractclause(Q).

% CONTRARY RELATION

contrary(sup(X),c(X,Y,B)) :- sup(X), sup(Y), all_different([X,Y]), benefit(B).
contrary(mnot(B,X),benefit(B,X)) :- benefit(B), sup(X).
contrary(Q,nothing) :- contractclause(Q).

% QUERY LINE

toBeProved([sup(2)]).